% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standings.R
\name{nfl_standings}
\alias{nfl_standings}
\title{Compute NFL Standings}
\usage{
nfl_standings(
  games,
  ...,
  ranks = c("CONF", "DIV", "DRAFT", "NONE"),
  tiebreaker_depth = c("SOS", "PRE-SOV", "POINTS", "RANDOM"),
  playoff_seeds = NULL,
  verbosity = c("MIN", "MAX", "NONE")
)
}
\arguments{
\item{games}{A data frame containing real or simulated game scores. Outside
of simulations, this is simply the output of \link[nflreadr:load_schedules]{nflreadr::load_schedules}.
The following variables are required as a minimum:
\describe{
\item{sim or season}{A season or simulation ID. Normally 1 - n simulated seasons.}
\item{game_type}{One of 'REG', 'WC', 'DIV', 'CON', 'SB' indicating if a
game was a regular season game or one of the playoff rounds.}
\item{week}{The week of the corresponding NFL season.}
\item{away_team}{Team abbreviation of the away team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{home_team}{Team abbreviation of the home team (please see
\code{\link{divisions}} for valid team abbreviations).}
\item{result}{Equals home score - away score.}
}
If tiebreakers beyond SOS are to be used, then the actual scores of the
home (\code{home_score}) and away (\code{away_score}) teams must also be available.}

\item{...}{currently not used}

\item{ranks}{One of \code{"DIV"}, \code{"CONF"}, \code{"DRAFT"}, or \code{"NONE"} to specify
which ranks - and thus the associated tiebreakers - are to be determined.
\itemize{
\item \code{"DIV"}: Adds the division ranking variable \code{div_rank}
\item \code{"CONF"} (default): \code{"DIV"} + the conference variable \code{conf_rank}. For better
performance, it is possible to set \code{playoff_seeds} to a value < 16 to make
the function skip tiebreakers of irrelevant conference ranks.
\item \code{"DRAFT"}: \code{"CONF"} + the draft variable \code{draft_rank}. This is the actual
pick in the draft based off game results. No trades of course.
}}

\item{tiebreaker_depth}{One of \code{"SOS"}, \code{"PRE-SOV"}, \code{"POINTS"} or \code{"RANDOM"}.
Controls which tiebreakers are to be applied. The implemented tiebreakers
are documented here \url{https://nflseedr.com/articles/tiebreaker.html}.
The values mean:
\itemize{
\item \code{"SOS"} (default): Apply all tiebreakers through Strength of Schedule. If there are
still remaining ties, break them through coin toss.
\item \code{"PRE-SOV"}: Apply all tiebreakers before Strength of Victory. If there are
still remaining ties, break them through coin toss. Why Pre SOV? It's the
first tiebreaker that requires knowledge of how OTHER teams played.
\item \code{"POINTS"}: Apply all tiebreakers through point differential. If there are
still remaining ties, break them through coin toss. This will go beyond SOS
and requires knowledge of points scored and points allowed. As this is not
usually part of season simulations, caution is advised in this case.
These tiebreakers should only be used if the scores are real or are
deliberately simulated.
\item \code{"RANDOM"}: Breaks all tiebreakers with a coin toss. I don't really know,
why I allow this...
}}

\item{playoff_seeds}{If \code{NULL} (the default), will compute all 16 conference
ranks. This means, the function applies conference tiebreakers to all
conference ranks. For better performance, it is possible to set this to a
value < 16 to make the function skip tiebreakers of those conference ranks.}

\item{verbosity}{One of \code{"MIN"}, \code{"MAX"}, or \code{"NONE"} allowing the user
to set the grade of verbosity of status reports. They mean:
\itemize{
\item \code{"MIN"} (default): Prints main steps of the process.
\item \code{"MAX"}: Prints all steps of the complete tiebreaking process.
\item \code{"NONE"}: No status reports at all. Do this to maximize the performance.
}}
}
\value{
A data.table of NFL standings including the ranks selected in the
argument \code{ranks}
}
\description{
Compute NFL Standings
}
\details{
nflseedR does not support all levels of tie-breakers at the moment. The
deepest tie-breaker currently is "best net points in all games".
After that, the decision is made at random. However, the need for
the last level ("best net touchdowns in all games") is extremely unlikely
in practice. Deeper levels than strength of schedule have never actually been
needed to resolve season-end standings since the NFL expanded to 32 teams.
}
\examples{
\donttest{
try({#to avoid CRAN test problems
  games <- nflreadr::load_schedules(2021:2022)
})
standings <- nflseedR::nfl_standings(games)
print(standings, digits = 3)
}
}
\seealso{
For more information on the implemented tiebreakers, see
\url{https://nflseedr.com/articles/tiebreaker.html}
}
