% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nflverse.R
\name{load_player_stats}
\alias{load_player_stats}
\title{Load Player Level Weekly Stats}
\usage{
load_player_stats(
  seasons = most_recent_season(),
  stat_type = c("offense", "kicking"),
  file_type = getOption("nflreadr.prefer", default = "qs")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to most recent season. If set to \code{TRUE}, returns all available data.}

\item{stat_type}{one of \code{offense} or \code{kicking}}

\item{file_type}{One of \code{"rds"} or \code{"qs"}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of week-level player statistics that aims to match NFL official box scores.
}
\description{
Load Player Level Weekly Stats
}
\examples{
\donttest{
  load_player_stats()
  load_player_stats(stat_type = "kicking")
}

}
\seealso{
\url{https://www.nflfastr.com/reference/load_player_stats.html}

\url{https://github.com/nflverse/nflfastr-data}

\code{vignette("Data Dictionary - Player Stats")} for the data dictionary
}
