% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{as_amounts}
\alias{as_amounts}
\alias{as_amounts-method}
\alias{as_amounts,CompositionMatrix-method}
\title{Coerce to Amounts}
\usage{
as_amounts(from, ...)

\S4method{as_amounts}{CompositionMatrix}(from)
}
\arguments{
\item{from}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} \code{\link{matrix}}.
}
\description{
Coerce to Amounts
}
\examples{
## Create a count matrix
A1 <- matrix(data = sample(1:100, 100, TRUE), nrow = 20)

## Coerce to compositions
B <- as_composition(A1)

## Row sums are internally stored before coercing to relative frequencies
totals(B)

## This allows to restore the source data
A2 <- as_amounts(B)

## Coerce to a data.frame
X <- data.frame(B)
head(X)
}
\seealso{
Other compositional data tools: 
\code{\link{as_composition}()}
}
\author{
N. Frerebeau
}
\concept{compositional data tools}
