% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{variation}
\alias{variation}
\alias{variation-method}
\alias{variation,CompositionMatrix-method}
\title{Variation Matrix}
\usage{
variation(x, ...)

\S4method{variation}{CompositionMatrix}(x)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{matrix}}.
}
\description{
Computes the variation matrix (Aitchison 1986, definition 4.4).
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Variation matrix
## (Aitchison 1986, definition 4.4)
(varia <- variation(coda))

## Cluster dendrogram
d <- as.dist(varia)
h <- hclust(d, method = "ward.D2")
plot(h)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{metric_var}()},
\code{\link{quantile}()},
\code{\link{scale}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
