% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovol.R
\name{partition}
\alias{partition}
\alias{partition,LogicalNeuroVol,integer-method}
\alias{partition,LogicalNeuroVol,numeric-method}
\alias{partition,DenseNeuroVol,numeric-method}
\title{Partition an image into a set of disjoint clusters}
\usage{
partition(x, k, ...)

\S4method{partition}{LogicalNeuroVol,integer}(x, k)

\S4method{partition}{LogicalNeuroVol,numeric}(x, k)

\S4method{partition}{DenseNeuroVol,numeric}(x, k)
}
\arguments{
\item{x}{the image to partition, represented as a 3D array.}

\item{k}{the number of clusters to form.}

\item{...}{additional arguments passed to the kmeans function.}
}
\value{
a 3D \code{array} where each voxel is assigned to a cluster.
}
\description{
This function partitions an image into a set of disjoint clusters using k-means clustering.
}
\examples{
# Load an example 3D image
library(neuroim2)
img <- read_vol(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))

# Partition the image into 5 clusters using default options
clusters <- partition(img, 5)


}
\seealso{
\code{\link{kmeans}}
}
