% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVector.R, R/SparseBrainVector.R
\docType{methods}
\name{seriesIter}
\alias{seriesIter}
\alias{seriesIter,BrainVector-method}
\alias{seriesIter,SparseBrainVector-method}
\title{seriesIter}
\usage{
seriesIter(x)

\S4method{seriesIter}{BrainVector}(x)

\S4method{seriesIter}{SparseBrainVector}(x)
}
\arguments{
\item{x}{the object to be iterated over. This is typically an instance of class \code{\linkS4class{BrainVector}}}
}
\value{
an \code{iter} object from the \code{iterators} package.
}
\description{
Construct a series iterator
}
\section{Methods (by class)}{
\itemize{
\item \code{BrainVector}: get a series iterator for a \code{\linkS4class{BrainVector}} instance

\item \code{SparseBrainVector}: get a seriesIter for a \code{\linkS4class{SparseBrainVector}} instance
}}
\examples{
## create a BrainVector with 10X10X10X10, where the last dimension is
## by convention the fourth dimension.
bvec <- BrainVector(array(rnorm(10*10*10*10), rep(10,4)), BrainSpace(rep(10,4), c(1,1,1)))
iter <- seriesIter(bvec)

## compute mean of each series
library(foreach)
library(iterators)
foreach(i=iter, .combine=c) \%do\% { mean(i) }
iter <- seriesIter(bvec)

## combine all series into a matrix
foreach(i=iter, .combine=rbind) \%do\% { i }

## scale all series, add as columns in matrix.
foreach(i=seriesIter(bvec), .combine=cbind) \%do\% { scale(i) }
}

