% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainVolume.R
\docType{methods}
\name{fill}
\alias{fill}
\alias{fill,BrainVolume,list-method}
\alias{fill,BrainVolume,matrix-method}
\title{Generic function to map values from one set to another using a user-supplied lookup table}
\usage{
fill(x, lookup)

\S4method{fill}{BrainVolume,list}(x, lookup)

\S4method{fill}{BrainVolume,matrix}(x, lookup)
}
\arguments{
\item{x}{the object to map values from}

\item{lookup}{the lookup table. The first column is the "key" the second column is the "value".}
}
\value{
a new object where the original values have been filled in with the values in the lookup table
}
\description{
Generic function to map values from one set to another using a user-supplied lookup table
}
\examples{
x <- BrainSpace(c(10,10,10), c(1,1,1))
vol <- BrainVolume(sample(1:10, 10*10*10, replace=TRUE), x)

## lookup table is list
lookup <- lapply(1:10, function(i) i*10)
ovol <- fill(vol, lookup)

## lookup table is matrix. First column is key, second column is value
names(lookup) <- 1:length(lookup)
lookup.mat <- cbind(as.numeric(names(lookup)), unlist(lookup))
ovol2 <- fill(vol, lookup.mat)
all.equal(as.vector(ovol2), as.vector(ovol))
}

