% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/Axis.R, R/BrainSpace.R
\docType{methods}
\name{dropDim}
\alias{dropDim}
\alias{dropDim,AxisSet2D,missing-method}
\alias{dropDim,AxisSet2D,numeric-method}
\alias{dropDim,AxisSet3D,missing-method}
\alias{dropDim,AxisSet3D,numeric-method}
\alias{dropDim,BrainSpace,missing-method}
\title{Generic function to drop a dimension from an object}
\usage{
dropDim(x, dimnum)

\S4method{dropDim}{AxisSet2D,numeric}(x, dimnum)

\S4method{dropDim}{AxisSet2D,missing}(x, dimnum)

\S4method{dropDim}{AxisSet3D,numeric}(x, dimnum)

\S4method{dropDim}{AxisSet3D,missing}(x, dimnum)

\S4method{dropDim}{BrainSpace,missing}(x)
}
\arguments{
\item{x}{a dimensioned object}

\item{dimnum}{the index of the dimension to drop}
}
\description{
Generic function to drop a dimension from an object
}
\examples{
x = BrainSpace(c(10,10,10), c(1,1,1))
x1 <- dropDim(x)
ndim(x1) == 2
dim(x1)[2] == 10
}

