% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.nifti.R
\name{hist.nifti}
\alias{hist.nifti}
\alias{hist.anlz}
\title{Histogram of Values in an Image}
\usage{
\method{hist}{nifti}(x, ..., mask)

\method{hist}{anlz}(x, ..., mask)
}
\arguments{
\item{x}{Object of class \code{nifti}}

\item{...}{Arguments passed to \code{\link{hist.default}}}

\item{mask}{object to subset the image.  If missing, then all 
values of the image are plotted.}
}
\value{
Output of \code{\link{hist}}
}
\description{
Computes and displays a histogram of the values
of an image with the option for a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 0
hist(img, mask = mask)
}
