% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyNIfTIHeader.R
\name{copyNIfTIHeader}
\alias{copyNIfTIHeader}
\title{Copy NIfTI Header to an array}
\usage{
copyNIfTIHeader(img, arr, drop_slots = c(".Data", "dim_"), drop = TRUE,
  onlylast = TRUE, warn = TRUE, ...)
}
\arguments{
\item{img}{object of class nifti to copy header}

\item{arr}{array to copy header information}

\item{drop_slots}{Slots not to copy over from header}

\item{drop}{Should \code{\link{dropImageDimension}} be called before returning?}

\item{onlylast}{if \code{drop = TRUE}, passed to \code{\link{dropImageDimension}},
if only the last dimensions should be dropped}

\item{warn}{if \code{drop = TRUE}, passed to \code{\link{dropImageDimension}}, 
for warning print out}

\item{...}{arguments to pass to \code{\link{nifti}}}
}
\value{
Object of class nifti the size of \code{arr}
}
\description{
Copies slots of a \code{nifti} object to an array.  This is useful if you're
subsetting 4D data and getting an array out
}
\examples{
img = nifti(img = array(rnorm(10^4), dim=rep(10, 4)), dim=rep(10, 4), datatype = 16)
sub = img[,,,1:3]
copyNIfTIHeader(img, sub)
sub = img[,,,1, drop=FALSE]
copyNIfTIHeader(img, sub) 
copyNIfTIHeader(img, sub, drop = FALSE) 
}
