% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_feature_NN.R
\name{validate_loss}
\alias{validate_loss}
\title{Validate/resolve a Keras loss}
\usage{
validate_loss(loss)
}
\arguments{
\item{loss}{character or function. If character, must be a valid
tf.keras loss identifier (e.g., "mse", "mae", "huber", "logcosh", ...).}
}
\value{
a callable loss (Python callable) or the original R function.
}
\description{
Validate/resolve a Keras loss
}
\examples{
\dontrun{
library(neuralGAM)
L <- neuralGAM:::validate_loss("huber")             # ok (Huber with default delta)
L <- neuralGAM:::validate_loss(function(y,t) tensorflow::tf$reduce_mean((y-t)^2))  # custom
}
}
\keyword{internal}
