% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goldbricker.R
\name{goldbricker}
\alias{goldbricker}
\title{Goldbricker - Identifying redundant nodes in networks using compared correlations}
\usage{
goldbricker(
  data,
  p = 0.05,
  method = "hittner2003",
  threshold = 0.25,
  corMin = 0.5,
  progressbar = TRUE
)
}
\arguments{
\item{data}{a data frame consisting of n rows (participants) and j columns (variables)}

\item{p}{a p-value threshold for determining if correlation pairs are "significantly different"}

\item{method}{method for comparing correlations. See ?cocor.dep.groups.overlap for a full list}

\item{threshold}{variable pairs which have less than the threshold proportion of significantly different
correlations will be considered "bad pairs"}

\item{corMin}{the minimum zero-order correlation between two items to be considered "bad pairs". Items
that are uncorrelated are unlikely to represent the same underlying construct}

\item{progressbar}{logical. prints a progress bar in the console}
}
\value{
\code{\link{goldbricker}} returns a list of class "\code{goldbricker}" which contains:

$proportion_matrix - a j x j matrix of proportions. Each proportion signifies the amount of significantly
different correlations between the given node pair (j x j)
$suggested_reductions - a vector of "bad pairs" (names) and their proportions (values)
$p - p value from input
$threshold - threshold from input
}
\description{
This function compares correlations in a psychometric network in order to identify nodes
which most likely measure the same underlying construct (i.e., are colinear)
}
\details{
In a given psychometric network, two nodes may be redundantly measuring the same underlying construct. If this is the case,
the correlations between those two variables and all other variables should be highly similar. That is, they should correlate
to the same degree with other variables.

The cocor package uses a p-value threshold to determine whether a pair of correlations to a third variable are
significantly different from each other. Goldbricker wraps the cocor package to compare every possible
combination of correlations in a psychometric network. It calculates the proportion of correlations which are
significantly different for each different pair of nodes.

Using the threshold argument, one can set the proportion of correlations which is deemed "too low". All pairs of nodes
which fall below this threshold are returned as defined "bad pairs".

Pairs can then be combined using the reduce_net function

Note: to quickly change the threshold, one may simply enter an object of class "goldbricker" in the data argument, and change the threshold.
The p-value cannot be modified in the same fashion, as re-computation is necessary.
}
\examples{
\donttest{
gb_depression <- goldbricker(depression, threshold=0.5)

reduced_depression <- net_reduce(data=depression, badpairs=gb_depression)

## Set a new threshold quickly
gb_depression_60 <- goldbricker(data=gb_depression, threshold=0.6)

}
}
