% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/known_population.r
\name{kp.estimator_}
\alias{kp.estimator}
\alias{kp.estimator_}
\title{Average personal network size estimates using known population method}
\usage{
kp.estimator_(resp.data, known.populations, attribute.names, weights,
  total.kp.size = NULL, alter.popn.size = NULL)

kp.estimator(resp.data, known.populations, attribute.names, weights,
  total.kp.size = 1, alter.popn.size = NULL)
}
\arguments{
\item{resp.data}{the dataframe that has the survey responses}

\item{known.populations}{the names of the columns in \code{resp.data}
that have respondents' reports about connections to known populations}

\item{attribute.names}{the names of the columns in \code{resp.data} that
determine the subgroups for which average degree is estimated}

\item{weights}{weights to use in computing the estimate}

\item{total.kp.size}{the size of the probe alters; i.e., the sum of the known population
sizes. if NULL, then this is set to 1}

\item{alter.popn.size}{the size of the population of alters; this is most
often the frame population, which is the default if nothing else is
specified; the size of the frame population is taken to be the sum
of the weights over all of resp.data}
}
\value{
the estimated average degree for respondents in each
        of the categories given by \code{attribute.names}
}
\description{
If given \code{attribute.names}, then this function produces
estimated average network sizes given by the groups that are defined by 
all combinations of the attributes; otherwise, it estimates the
average personal network size for the entire frame population.
}
\section{Technical note}{

The estimated average degree is 
\eqn{(\sum y_{F_\alpha, A} / N_A) \times
     N_F / N_{F_\alpha}}
here, we estimate \eqn{N_F / N_{F_\alpha}} by dividing the
total of all respondents' weights by the sum of
the weights for respondents in each cell \eqn{\alpha}.
}

\section{TODO}{

\itemize{
\item{ handle case where attribute.names is NULL (should compute overall average)}
\item{ handle missing values }
\item{ integrate the individual-level estimator above, kp.degree.estimator}
\item{ finish documentation for NSE version }
\item{ make unit tests }
\item{ think about how to elegantly add options for dbar_(P,Q) vs dbar_(Q,P)}
}
}

