% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/treeNetwork.R
\name{as.treeNetwork}
\alias{as.treeNetwork}
\title{Convert an R hclust or dendrogram object into a treeNetwork list.}
\usage{
as.treeNetwork(d, root)
}
\arguments{
\item{d}{An object of R class \code{hclust} or \code{dendrogram}.}

\item{root}{An optional name for the root node. If missing, use the first argument
variable name.}
}
\description{
\code{as.treeNetwork} converts an R hclust or dendrogram object into a list suitable
for use by the \code{treeNetwork} function.
}
\details{
\code{as.treeNetwork} coverts R objects of class \code{hclust} or
\code{dendrogram} into a list suitable for use with the \code{treeNetwork} function.
}
\examples{
# Create a hierarchical cluster object and display with treeNetwork
## dontrun
hc <- hclust(dist(USArrests), "ave")
treeNetwork(as.treeNetwork(hc))
}

