% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.netmeta.R
\name{print.summary.netmeta}
\alias{print.summary.netmeta}
\title{Print detailed results of network meta-analysis}
\usage{
\method{print}{summary.netmeta}(
  x,
  sortvar,
  fixed = x$x$fixed,
  random = x$x$random,
  prediction = x$prediction,
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  all.treatments = x$all.treatments,
  details = TRUE,
  nma = TRUE,
  backtransf = x$backtransf,
  nchar.trts = x$nchar.trts,
  nchar.studlab = x$nchar.studlab,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.I2 = gs("digits.I2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  truncate,
  text.truncate = "*** Output truncated ***",
  legend = TRUE,
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.netmeta}.}

\item{sortvar}{An optional vector used to sort individual studies
(must be of same length as \code{x$TE}).}

\item{fixed}{A logical indicating whether results for the fixed
effects / common effects model should be printed.}

\item{random}{A logical indicating whether results for the random
effects model should be printed.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{details}{A logical indicating whether further details for
individual studies should be printed.}

\item{nma}{A logical indicating whether summary results of
network meta-analysis should be printed.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistics, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{truncate}{An optional vector used to truncate the printout of
results for individual studies (must be a logical vector of
length corresponding to the number of pairwise
comparisons \code{x$TE} or contain numerical values).}

\item{text.truncate}{A character string printed if study results
were truncated from the printout.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments.}
}
\description{
Print method for objects of class \code{summary.netmeta}.
}
\examples{
data(Senn2013)

# Conduct fixed effects network meta-analysis
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                random = FALSE, ref = "plac")
snet1 <- summary(net1)
print(snet1, digits = 3)

# Only show individual study results for multi-arm studies
#
print(snet1, digits = 3, truncate = multiarm)

# Only show first three individual study results
#
print(snet1, digits = 3, truncate = 1:3)

# Only show individual study results for Kim2007 and Willms1999
#
print(snet1, digits = 3, truncate = c("Kim2007", "Willms1999"))

# Only show individual study results for studies starting with the
# letter "W"
#
print(snet1, ref = "plac", digits = 3,
      truncate = substring(studlab, 1, 1) == "W")

\dontrun{
# Conduct random effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD",
                fixed = FALSE, ref = "plac")
print(summary(net2), digits = 3)
}

}
\seealso{
\code{\link{netmeta}}, \code{\link{summary.netmeta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
