% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnetmap.R
\name{check_network_sf}
\alias{check_network_sf}
\title{Internal checks before ggnetmap and ggcentrality}
\usage{
check_network_sf(n, m, lkp = NULL, m_name = NULL, n_name = "vertex.names")
}
\arguments{
\item{n}{A \code{network} or \code{igraph} object.}

\item{m}{A \code{sf} object.}

\item{lkp}{An optional lookup table.}

\item{m_name}{Optional \code{character}, name of field in \code{m} and of
column in \code{lkp}.}

\item{n_name}{Optional \code{character}, name of vertex attribute in \code{n}
and of column in \code{lkp}.}
}
\value{
A list with a \code{network} or \code{igraph} object with only the
vertices present in the \code{sf} object as the first element and a list
with two vectors, one of features in \code{m} present
both in the lookup table and in \code{n}, the other of nodes in \code{n}
present both in the lookup table and in \code{m}
}
\description{
Checks whether the proper packages are installed, whether the parameters are
of the proper classes, whether the network-map link is possible, then
performs the link.
}
