% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{NetSet-class}
\alias{NetSet-class}
\title{An S4 class representing a single network with a network permutation function applied to it.}
\description{
This class represents the results of applying a network permutation function, such as a jackknife, or rewiring algorithm, to a single network.
}
\details{
For constructor see: For constructor see: \code{\link{net_apply}}
}
\section{Slots}{

\describe{
\item{\code{fun.name}}{character. The name of the network permutation function applied}

\item{\code{fun}}{function. The permutation function applied}

\item{\code{fun.args}}{list. The arguments supplied to the permutation function}

\item{\code{orig.net}}{Net. The original network}

\item{\code{orig.net.name}}{character. The name of the original network}

\item{\code{nets}}{list. A list of Net objects, each corresponding to a instance of the manipulated original network}

\item{\code{nets.names}}{character. The names of the manipulated networks.}

\item{\code{node.variables}}{list. Node variables of the original network}

\item{\code{iter}}{logical. A flag to indicate that the permutation function was repeated with the same arguements. Currently unused.}
}}

