% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphInstances.R
\name{morphInstances}
\alias{morphInstances}
\title{Morphing of two networks with a convex combination of the coordinates.}
\usage{
morphInstances(x, y, alpha, point.matching = NULL,
  point.matching.algorithm = getOptimalPointMatching)
}
\arguments{
\item{x}{[\code{Network}]\cr
First network.}

\item{y}{[\code{Network}]\cr
Second network.}

\item{alpha}{[\code{numeric(1)}]\cr
Coeffiecient alpha for convex combination.}

\item{point.matching}{[\code{matrix} | NULL]\cr
Point matching which shall be used for morphing. If \code{NULL}, an optimal
point matching is generated via function \code{\link{getOptimalPointMatching}}.
Default is \code{NULL}. Currently it is just possible to pass a point matching
for instances without depots.}

\item{point.matching.algorithm}{[\code{function}]\cr
Algorithm used to find a point matching. Default is \code{\link{getOptimalPointMatching}}.}
}
\value{
[\code{Network}]
  Morphed network
}
\description{
This function takes two (clustered) networks with equal number of nodes and,
if present, equal number of depots, and generates another instance by applying
a convex combination to the coordinates of node pairs. The node pairs are
determined by a point matching algorithm, which solves this assignement problem
via a integer programming procedure.
If both instances contain depots, point matching is done separately on depots
and the remaining nodes.
}
\examples{
x = generateRandomNetwork(n.points = 40L, n.depots = 2L)
y = generateClusteredNetwork(n.points = 40L, n.cluster = 2L, n.depots = 2L)
z = morphInstances(x, y, alpha = 0.2)
\dontrun{
library(gridExtra)
plot.list = list(autoplot(x), autoplot(z), autoplot(y))
plot.list$nrow = 1
do.call(grid.arrange, plot.list)
}
}
\seealso{
\code{\link{visualizeMorphing}}, \code{\link{visualizePointMatching}}
}

