% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowball.R
\name{snowball.sampling}
\alias{snowball.sampling}
\title{Snowball sampling}
\usage{
snowball.sampling(G, samn)
}
\arguments{
\item{G}{an \code{igraph} object.}

\item{samn}{is a size of snowball sample that will be samples from \code{G}.}
}
\value{
\item{\code{subG}}{an induced subgraph of \code{G} sampled using snowball sampling.}
\item{\code{ind}}{a set of index of samples.}
}
\description{
Sampling from one graph to its induced subgraph depending on network structure.
}
\examples{
library(netdep)
library(igraph)
G = latent.netdep(n.node = 200, rho = 0.2, dep.factor = -3, dep.range = c(-10, 0))
subG = snowball.sampling(G, 100)

}
