% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayPredict.R
\name{pathwayPredict}
\alias{pathwayPredict}
\title{Summary of predicted and observed response values along a pathway}
\usage{
pathwayPredict(x, path, newdata = NULL)
}
\arguments{
\item{x}{An object of class "netSEM", the returned list from \code{netSEMm}.}

\item{path}{A string form for a pathway, the default output format from \link[netSEM]{pathwayRMSE}.}

\item{newdata}{A data frame of the stress variable. The default is NULL.}
}
\value{
An object of class pathway, which is a list of the following items:

\itemize{
\item "pathway": A string form that shows the pathway.
\item "RMSE": A value of the root mean squared error.
\item "Resp": A matrix. The first column is the observed response values and 
the second is the predicted response values.
}
}
\description{
Predict response variable values along a pathway
}
\examples{
# Load the sample acrylic data set
data(acrylic)
ans <- netSEMm(acrylic)
paths <- pathwayRMSE(ans,maxlen=3)
response <- pathwayPredict(ans, paths[10,2])
response

}
\seealso{
\link[netSEM]{pathwayRMSE}, \link[netSEM]{netSEMm}
}
