% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.netSEM}
\alias{plot.netSEM}
\title{Plotting of netSEM diagram}
\usage{
\method{plot}{netSEM}(x, res, plot.save = FALSE, filename = NULL,
  style = TRUE, label = TRUE, ...)
}
\arguments{
\item{x}{An object of class "netSEM", the returned list from \code{netSEMm}. Plotting uses the first element of this list (table) in which the first column of it is endogenous variable, second column is variable and other columns are corresponding best functional form, r-squared, adj-r-squared, P-value1, P-value2 and P-value3.}

\item{res}{An object of class "subsetData", the returned list from \code{subsetData}. Stronger Solid lines represent relationship with higher adjusted R-sqr and weak dotted lines with less than the first cutoff.}

\item{plot.save}{True/False, it saves the network diagram plot as png file. The default is false.}

\item{filename}{A character string naming a file to save as a png file.}

\item{style}{True/False, it plots the first interval in the network diagram with dotted weak line. The default is True.}

\item{label}{True/False, it use label to express model and Adj-R2 in the path between variables. The default is True.}

\item{...}{A S3 generic/method consistency.}
}
\value{
An html style plot of pairwise relationship pathway diagram between exogenous variables and an endogenous variable. 
Arrows show relationships between each variable with given statistical relations along the connection lines.
}
\description{
Plot netSEM result
plot.netSEM plots a structural equation network model diagram based on best functional form for each selected pairwise variable.
}
\examples{
# Load acrylic data set
data(acrylic)
# Build a semi-gSEM model
ans <- netSEMm(acrylic)
# Subset dataset with three cutoff
res <- subsetData(ans,cutoff=c(0.3,0.6,0.8))
# Plot the network model 
plot(ans,res)
# plot the network diagram and save as 'semplot.png' file
#plot(ans,res,plot.save=TRUE,filename=c("semplot"))


}
\seealso{
\link[netSEM]{netSEMm}
}
