\name{surCoin}
\alias{surCoin}
\title{Networked coincidences from a data frame.}
\description{
\code{surCoin} produces a network object of coincidences from a data frame converting variables into dichotomies. 
}
\value{
This function creates a netCoin object (or igraph) and, if stated, a folder in the computer with an HTML document named index.html which contains the produced graph. This file can be directly opened with your browser and sent to a web server to work properly.
}

\usage{
surCoin(data,variables=names(data), commonlabel=NULL,
        dichotomies=NULL, valueDicho=1, metric=NULL, exogenous=NULL,
        weight=NULL, subsample=FALSE,
        minimum=1, maximum=nrow(data), sort=FALSE, decreasing=TRUE,
        frequency=FALSE, percentages=TRUE,
        procedures="Haberman", criteria="Z", Bonferroni=FALSE,
        support=-Inf, minL=-Inf, maxL=Inf,
        directed=FALSE, diagonal=FALSE, sortL=NULL, decreasingL=TRUE,
        igraph=FALSE, dir=NULL, ...)
}
\arguments{
  \item{data}{a data frame}
  \item{variables}{a vector of variables included in the previous data frame}
  \item{commonlabel}{a vector of variables whose names are to be included in nodes labels}
  \item{dichotomies}{a vector of dichotomous variables to appear as just one categorie}
  \item{valueDicho}{value to be selected for dichotomous variables. Default is 1}
  \item{metric}{a vector of metrics}
  \item{exogenous}{a vector of variables whose relations amongst them are of no interest. None by default}
  \item{weight}{a vector of weights. Optimal for data.framed tables}
  \item{subsample}{retrict the analysis to scenarios with at least one event}
  \item{minimum}{minimum frequency to be considered}
  \item{maximum}{maximum frequency to be considered}
  \item{sort}{sort the coincidence matrix according to frequency of events}
  \item{decreasing}{decreasing or increasing sort of the matrix}
  \item{frequency}{a logical value true if frequencies are to be shown. Default=FALSE.}
  \item{percentages}{a logical value true if percentages are to be shown. Default=TRUE.}
  \item{procedures}{a vector of statistics of similarity. See below.}
  \item{criteria}{statistic to be use for selection criteria.}
  \item{Bonferroni}{Bonferroni criterium of the signification test.}
  \item{support}{minimum value of the frequency of the coincidence to be edged}
  \item{minL}{minimum value of the statistic to include the edge in the list.}
  \item{maxL}{maximum value of the statistic to include the edge in the list.}
  \item{directed}{includes same edges only once.}
  \item{diagonal}{includes auto-links}
  \item{sortL}{sort the list according to the values of a statistic. See below}
  \item{decreasingL}{order in a decreasing way.}
  \item{igraph}{Produces an igraph object instead of a netCoin object if TRUE.}
  \item{dir}{a "character" string representing the directory where the web files will be saved.}
  \item{...}{Any \link{netCoin} argument.}
}
\details{
Possible measures in procedures are 
\itemize{
\item{Frequencies (f), Relative frequencies (x), Conditional frequencies (i), Coincidence degree (cc), Probable degree (cp),}
\item{Expected (e), Confidence interval (con)}
\item{Matching (m), Rogers & Tanimoto (t), Gower (g), Sneath (s), Anderberg (and),}
\item Jaccard (j), Dice (d), antiDice (a), Ochiai (o), Kulczynski (k),
\item Hamann (ham), Yule (y), Pearson (p), odds ratio (od), Rusell (r), 
\item Haberman (h), Z value of Haberman (z), 
\item Hypergeometric p greater value (hyp).
\item Convert a matrix into an edge list (shape).
}
}

\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{http://casus.usal.es/blog/modesto-escobar/}
}
\examples{
# A data frame with two variables Gender and Opinion
frame<-data.frame(Gender=c(rep("Man",3),rep("Woman",3)),
                  Opinion=c("Yes","Yes","No","No","No","Yes"))
surCoin(frame,commonlabel="") # network object
}

