% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predSummary.R
\name{predSummary}
\alias{predSummary}
\title{Summarise prediction performance metrics}
\usage{
predSummary(output, family = "")
}
\arguments{
\item{output}{data.frame with columns \code{testy} containing observed response
from test folds; \code{predy} predicted response; \code{predyp} (optional) predicted
probabilities for classification to calculate ROC AUC}

\item{family}{Optional character value to support specific glmnet models e.g.
'mgaussian', 'cox'.}
}
\value{
An object of class 'predSummary'. For classification a list is
returned containing the confusion matrix table and a vector containing
accuracy and balanced accuracy for classification, ROC AUC for
classification. For regression a vector containing RMSE and R^2 is
returned.
}
\description{
Quick function to calculate performance metrics: confusion matrix, accuracy
and balanced accuracy for classification; ROC AUC for binary classification;
RMSE and R^2 for regression. Multi-class AUC is returned for multinomial
classification.
}
\details{
For multinomial classification, multi-class AUC as defined by Hand and Till
is calculated using \code{\link[pROC:multiclass]{pROC::multiclass.roc()}}.
}
