% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{plot_var_ranks}
\alias{plot_var_ranks}
\alias{hist_var_ranks}
\title{Plot variable importance rankings}
\usage{
plot_var_ranks(
  x,
  sort = TRUE,
  scheme = NULL,
  cex = 1,
  corral.width = 0.75,
  ...
)

hist_var_ranks(x, sort = TRUE, scheme = NULL)
}
\arguments{
\item{x}{A \code{nestcv.glmnet} or \code{nestcv.train} fitted object or a list of
these, or a \code{repeatcv} object.}

\item{sort}{Logical whether to sort variable by mean rank.}

\item{scheme}{Optional vector of colours which is passed to
\code{ggplot2::scale_color_manual()}. The vector is recycled, so a single value
will colour all points in the same colour, while two values will lead to
alternating row colours.}

\item{cex}{Scaling for adjusting point spacing. See
\code{ggbeeswarm::geom_beeswarm()}.}

\item{corral.width}{Numeric specifying width of corral, passed to
\code{geom_beeswarm}}

\item{...}{Optional arguments passed to \code{ggbeeswarm::geom_beeswarm()} e.g.
\code{size}.}
}
\value{
A ggplot2 plot.
}
\description{
Plots variables selected in models ranked by variable importance across the
outer folds as well as the final model.
}
