% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_db.R
\name{neon_delete_db}
\alias{neon_delete_db}
\title{delete the local NEON database}
\usage{
neon_delete_db(db_dir = neon_db_dir(), ask = interactive())
}
\arguments{
\item{db_dir}{neon database location (configurable with the NEONSTORE_DB
environmental variable)}

\item{ask}{Ask for confirmation first?}
}
\description{
delete the local NEON database
}
\details{
Just a helper function that deletes the NEON database
files, which are found under \code{file.path(neon_dir(), "database")}.
This does not delete downloaded raw data, which can easily be
re-loaded with \code{neon_store()}.  Usually unnecessary but can be
helpful in resetting a corrupt database.

If you want to delete all raw data files downloaded by neonstore
as well, simply delete the entire directory given by \code{\link[=neon_dir]{neon_dir()}}
}
\examples{

# Create a db
dir <- tempfile()
db <- neon_db(dir)

# Delete it
neon_delete_db(dir, ask = FALSE)


}
