% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_db.R
\name{neon_delete_db}
\alias{neon_delete_db}
\title{delete the local NEON database}
\usage{
neon_delete_db(dir = neon_dir(), ask = interactive())
}
\arguments{
\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{ask}{Ask for confirmation first?}
}
\description{
delete the local NEON database
}
\details{
Just a helper function that deletes the NEON database
files, which are found under \code{file.path(neon_dir(), "database")}.
This does not delete downloaded raw data, which can easily be
re-loaded with \code{neon_store()}.  Usually unnecessary but can be
helpful in resetting a corrupt database.

If you want to delete all raw data files downloaded by neonstore
as well, simply delete the entire directory given by \code{\link[=neon_dir]{neon_dir()}}
}
\examples{

# Create a db
dir <- tempfile()
neon_db(dir)

# Delete it
neon_delete_db(dir, ask = FALSE)


}
