% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncope_01_population.R
\name{syncope_01_population}
\alias{syncope_01_population}
\title{Syncope-01 Populations}
\usage{
syncope_01_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_09_col,
  esituation_10_col,
  esituation_11_col,
  esituation_12_col,
  evitals_04_col
)
}
\arguments{
\item{df}{Main data frame containing EMS records.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{The column containing unique record identifiers for
each encounter.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient age (numeric).}

\item{epatient_16_col}{Column for the patient age units (e.g., "Years",
"Months").}

\item{eresponse_05_col}{Column containing response type codes, specifically
911 codes.}

\item{esituation_09_col}{Column with primary symptoms associated with the
patient encounter.}

\item{esituation_10_col}{Column with other associated symptoms.}

\item{esituation_11_col}{Column for primary impression code.}

\item{esituation_12_col}{Column for secondary impression codes.}

\item{evitals_04_col}{Column with ECG information if available.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Syncope-01, and categorizes
records to identify needed information for the calculations.

Identifies key categories to identify potential syncope (fainting) cases
based on specific criteria and calculates related ECG measures. This function
segments the data by age into adult and pediatric populations.
}
\examples{

# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5)

  )

  # situation table
  situation_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    esituation_09 = c(rep("R55", 3), rep("R40.4", 2)),
    esituation_10 = c(rep("R40.4", 2), rep("R55", 3)),
    esituation_11 = c(rep("R55", 3), rep("R40.4", 2)),
    esituation_12 = c(rep("R40.4", 2), rep("R55", 3)),
  )

  # vitals table
  vitals_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    evitals_04 = rep("15 Lead", 5)

  )

  # test the success of the function
  result <- syncope_01_population(patient_scene_table = patient_table,
                         response_table = response_table,
                         situation_table = situation_table,
                         vitals_table = vitals_table,
                         erecord_01_col = erecord_01,
                         epatient_15_col = epatient_15,
                         epatient_16_col = epatient_16,
                         eresponse_05_col = eresponse_05,
                         esituation_09_col = esituation_09,
                         esituation_10_col = esituation_10,
                         esituation_11_col = esituation_11,
                         esituation_12_col = esituation_12,
                         evitals_04_col = evitals_04
                         )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
