% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttr_01.R
\name{ttr_01}
\alias{ttr_01}
\title{TTR-01 Calculation}
\usage{
ttr_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  arrest_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  transport_disposition_col,
  earrest_01_col,
  evitals_06_col,
  evitals_07_col,
  evitals_10_col,
  evitals_12_col,
  evitals_14_col,
  evitals_23_col,
  evitals_26_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing the dataset to analyze. Default
is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{arrest_table}{A data frame or tibble containing only the earrest fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{A column specifying unique patient records.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{A column indicating the patient’s age in numeric form.}

\item{epatient_16_col}{A column specifying the unit of patient age (e.g.,
"Years", "Days").}

\item{eresponse_05_col}{A column specifying the type of response (e.g., 911
codes).}

\item{transport_disposition_col}{A column specifying transport disposition
for the patient.}

\item{earrest_01_col}{A column containing cardiac arrest data.}

\item{evitals_06_col}{A column containing systolic blood pressure (SBP) data
from initial vital signs.}

\item{evitals_07_col}{A column containing diastolic blood pressure (DBP) data
from initial vital signs.}

\item{evitals_10_col}{A column containing heart rate data from initial vital
signs.}

\item{evitals_12_col}{A column containing spO2 data from the initial vital
signs.}

\item{evitals_14_col}{A column containing respiratory rate data from initial
vital signs.}

\item{evitals_23_col}{A column containing total Glasgow Coma Scale (GCS)
scores from initial vital signs.}

\item{evitals_26_col}{A column containing alert, verbal, painful,
unresponsive (AVPU) vital signs.}

\item{...}{Additional arguments passed to the \code{summarize_measure} function.}
}
\value{
A tibble summarizing results for three population groups (Adults, and
Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (Adults, Peds).
\code{numerator}: Count of incidents where all applicable vital signs are taken.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where all applicable vital signs are taken.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function calculates the TTR-01 measure, which evaluates the completeness
of vitals documentation for patients not experiencing cardiac arrest who were
also not transported during a 911 response. It determines the total
population, adult population, and pediatric population meeting the criteria
for the TTR_01 measure.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05", "2025-02-01",
    "2025-01-01", "2025-06-01")),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01", "2023-02-01",
    "2023-01-01", "1970-06-01")),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    earrest_01 = rep("No", 5),
    evitals_06 = c(100, 90, 80, 70, 85),
    evitals_07 = c(80, 90, 50, 60, 87),
    evitals_10 = c(110, 89, 88, 71, 85),
    evitals_12 = c(50, 60, 70, 80, 75),
    evitals_14 = c(30, 9, 8, 7, 31),
    evitals_23 = c(6, 7, 8, 9, 10),
    evitals_26 = c(3326007, 3326005, 3326003, 3326001, 3326007),
    edisposition_30 = c(4230013, 4230009, 4230013, 4230009, 4230013)
  )

  # Run function with the first and last pain score columns
  ttr_01(
    df = test_data,
    erecord_01_col = erecord_01,
    incident_date_col = incident_date,
    patient_DOB_col = patient_dob,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    earrest_01_col = earrest_01,
    evitals_06_col = evitals_06,
    evitals_07_col = evitals_07,
    evitals_10_col = evitals_10,
    evitals_12_col = evitals_12,
    evitals_14_col = evitals_14,
    evitals_23_col = evitals_23,
    evitals_26_col = evitals_26,
    transport_disposition_col = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
