% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MemoryGroup.R
\docType{class}
\name{MemoryGroup}
\alias{MemoryGroup}
\title{CF group in memory}
\description{
This class represents a CF group in memory. It descends from
\link{NCGroup} and functions as such with the exception that it has no
associated \code{CFResource} and the \code{handle} field thus always returns \code{NULL}.
}
\details{
This object descends from \link{NCGroup} and functions as such with the
exception that it has no associated \code{CFResource} and the \code{handle} field
thus always returns \code{NULL}.
}
\section{Super classes}{
\code{\link[ncdfCF:NCObject]{ncdfCF::NCObject}} -> \code{\link[ncdfCF:NCGroup]{ncdfCF::NCGroup}} -> \code{MemoryGroup}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{handle}}{Return NULL as a MemoryGroup has no resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MemoryGroup-new}{\code{MemoryGroup$new()}}
\item \href{#method-MemoryGroup-clone}{\code{MemoryGroup$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-attribute'><code>ncdfCF::NCObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="print_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-print_attributes'><code>ncdfCF::NCObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="addAuxiliaryLongLat"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-addAuxiliaryLongLat'><code>ncdfCF::NCGroup$addAuxiliaryLongLat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="axes"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-axes'><code>ncdfCF::NCGroup$axes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="find_by_name"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-find_by_name'><code>ncdfCF::NCGroup$find_by_name()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="fullnames"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-fullnames'><code>ncdfCF::NCGroup$fullnames()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="grid_mappings"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-grid_mappings'><code>ncdfCF::NCGroup$grid_mappings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="hierarchy"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-hierarchy'><code>ncdfCF::NCGroup$hierarchy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="print"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-print'><code>ncdfCF::NCGroup$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCGroup" data-id="variables"><a href='../../ncdfCF/html/NCGroup.html#method-NCGroup-variables'><code>ncdfCF::NCGroup$variables()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryGroup-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryGroup$new(id, name, fullname, parent, title, history)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The identifier of the group.}

\item{\code{name}}{The name of the group.}

\item{\code{fullname}}{The fully qualified name of the group.}

\item{\code{parent}}{The parent group of this group. The \code{parent} of the root
group is \code{NULL}.}

\item{\code{title, history}}{Title and history attributes for the group.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
