% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/programs.R
\docType{data}
\name{programs}
\alias{programs}
\title{NBER working paper programs}
\format{
Data frame with columns
\describe{
\item{program}{Program code}
\item{program_desc}{Program description}
\item{program_category}{Program category based on Chari and Goldsmith-Pinkham (2017)}
}
}
\source{
\href{https://www.nber.org}{National Bureau of Economic Research}
}
\usage{
data(programs)
}
\description{
Crosswalk between NBER program codes, descriptions and categories.
}
\examples{
programs

if (require('dplyr')) {
paper_programs \%>\% count(program) \%>\% left_join(programs)
}

}
\references{
Chari, A. and P. Goldsmith-Pinkham (2017).
Gender Representation in Economics Across Topics and Time: Evidence from the NBER Summer Institute.
NBER Working Paper No. 23953,
National Bureau of Economic Research.
}
\keyword{datasets}
