% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf-pmmeans-class-generic.R
\name{nauf.pmm.stan}
\alias{as.array.nauf.pmm.stan}
\alias{as.data.frame.nauf.pmm.stan}
\alias{as.data.frame.summ.nauf.pmm.stan}
\alias{as.matrix.nauf.pmm.stan}
\alias{nauf.pmm.stan}
\alias{print.nauf.pmm.stan}
\alias{print.summ.nauf.pmm.stan}
\alias{summary.nauf.pmm.stan}
\title{Posterior samples of marginal means from Bayesian \code{nauf} models.}
\usage{
\method{summary}{nauf.pmm.stan}(object, probs = c(0.025, 0.975),
  type = c("link", "response"), ...)

\method{print}{summ.nauf.pmm.stan}(x, row.names = FALSE, mcse = FALSE,
  rhat = NULL, ...)

\method{as.array}{nauf.pmm.stan}(x, ...)

\method{as.matrix}{nauf.pmm.stan}(x, ...)

\method{print}{nauf.pmm.stan}(x, ...)

\method{as.data.frame}{nauf.pmm.stan}(x, row.names = NULL, optional = FALSE,
  ...)

\method{as.data.frame}{summ.nauf.pmm.stan}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{object}{A \code{nauf.pmm.stan} object.}

\item{probs}{A vector of quantiles to calculate for the estimates.
The default is a 95% credible interval (also called an uncertainty interval). 
The median (0.5) is always added regardless of whether it is specified.}

\item{type}{If \code{"link"} (the default), then the estimates are not 
transformed prior to summary; if \code{"response"}, then the inverse link 
function in the object's \code{family} element is applied to the 
\code{samples} element prior to summary.}

\item{...}{See the \code{Methods} section.}

\item{x}{Either a \code{nauf.pmm.stan} object, or the \code{summ.nauf.pmm.stan} 
object returned by calling \code{summary} on a \code{nauf.pmm.stan} object.}

\item{row.names, optional}{Changes from the defaults are ignored.}

\item{mcse}{A logical indicating whether the Monte Carlo standard errors
should be printed (default \code{FALSE} since the column is always recoverable
by dividing the \code{SD} column by the square root of the \code{ESS} column).}

\item{rhat}{An optional logical indicating whether or not to print the 
Gelman-Rubin R-hat statistic.  If \code{rhat = NULL} (the default), then 
the \code{Rhat} column of the summary is only printed if any of the 
statistics are greater that \code{1.1}. Regardless of the value of the 
\code{rhat} argument, a warning is issued if any of the statistics are 
greater than \code{1.1}.}
}
\value{
The returned object depends on the function.  See the 'Methods'
  section.
}
\description{
When \code{\link{nauf_pmmeans}} is used with Bayesian regressions, the 
elements of the resulting \code{\link{nauf.pmm.list}} have class 
\code{nauf.pmm.stan}.
}
\details{
The \code{nauf.pmm.stan} object is a list with the following elements.

\describe{
  \item{names}{A data frame with the levels of each factor (or 'inc_1' for
    covariates), with one row for each element in the third dimension of 
    \code{samples}.}
  \item{contrasts}{The fixed effects model matrix showing the contrasts 
    applied to the regression coefficients (rows correspond to the 
    \code{names} element).}
  \item{samples}{An array with three dimensions. The first corresponds to 
    iterations, the second to chains, and the third to parameters (the same 
    structure returned by \code{\link[rstan]{as.array.stanfit}}).}
  \item{family}{The regression family.}
  \item{inv.lbl}{The label of the inverse link (e.g. probability, rate, etc.).}
  \item{misc}{A list with additional information based on the type of model.}
}
}
\section{Methods}{

\describe{
  \item{summary}{Returns a data frame with class
    \code{summ.nauf.pmm.stan}, with means, standard deviations, medians, mean 
    absolute differences, the posterior probability that the estimate is 
    greater than zero, quantiles specified in \code{probs}, the effective 
    sample size, Monte Carlo standard error, and Gelman-Rubin R-hat statistic.
    Additional arguments in \code{...} are ignored.  Quantiles, effective
    samples size, and Monte Carlo standard error, and R-hat statistics are
    computed using \code{\link[rstan]{monitor}}.}
  \item{print}{For \code{summ.nauf.pmm.stan} objects, the data frame is
    printed, omitting the Monte Carlo standard error and 
    R-hat statistic based on \code{mcse} and \code{rhat}.  If the inverse
    link function was used, then a message indicating the response type
    is also printed. Additional arguments in \code{...} are passed to 
    \code{\link[base]{print.data.frame}}. For \code{nauf.pmm.stan} objects,
    first \code{summary} is called, passing along \code{...},
    and then print is called on the resulting \code{summ.nauf.pmm.stan}, also
    passing along \code{...} arguments.}
  \item{as.data.frame}{For \code{summ.nauf.pmm.stan} objects, removes the 
    \code{data.frame} contained in a \code{summ.nauf.pmm.stan}.  Additional
    arguments in \code{...} are ignored. For \code{nauf.pmm.stan} objects,
    first \code{summary} is called, passing along \code{...}, and then
    \code{as.data.frame} is called on the resulting \code{summ.nauf.pmm.stan}
    object, ignoring \code{...} arugments.}
  \item{as.array}{Returns the \code{samples} element of a 
    \code{nauf.pmm.stan} object. Additional arguments in \code{...} are 
    ignored.}
  \item{as.matrix}{Returns the \code{samples} element of a 
    \code{namf.pmm.stan} object, flattening the array into a matrix such that 
    the rows represent iterations ordered by chain and the columns represent 
    parameters.}
}
}

