% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_balance_matrices.R
\name{create_balance_matrices}
\alias{create_balance_matrices}
\title{Create matrix of balance constraints for linear program}
\usage{
create_balance_matrices(X, z, N, nvars, kc2, q_s, return = "all")
}
\arguments{
\item{X}{a matrix or data frame containing constraints in the columns. The number
of rows should equal the length of \code{z}. Balance is achieved when a constraint
sums to 0, such that numbers closer to 0 are better. When a constraint
does not apply to a particular unit, the entry should be \code{NA}.
This should typically be generated using \code{\link{generate_constraints}()}.}

\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{N}{the total number of available controls in the data.}

\item{q_s}{a named vector or matrix indicating how many units are to be selected from each stratum.
If there is one control group and all treated units are desired, this can be a vector; otherwise,
this should have one row per treatment group, where the order of the rows matches the order of
the levels of \code{z}, including the treated level.
If \code{NULL}, \code{ratio} should be specified. If both are specified, \code{q_s} will take priority.
Typically, if the desired ratio is not feasible for every stratum, \code{q_s} should be generated
using \code{\link{generate_qs}()}.}

\item{return}{one of "all", "A", or "X", denoting whether all matrices should be
returned, or just A or just the X matrix blocks.}
}
\value{
A list containing up to three elements:
\describe{
\item{\code{A}}{The matrix of covariate values and +/- 1s that are used as coefficients
for the unit indicators and the epsilons in order to set the epsilons equal to
the covariate imbalances.}
\item{\code{x_blk}}{The covariate values used as coefficients for the unit
indicators in the objective function.}
}
}
\description{
This creates the matrix of constraints that seek covariate balance for use in \code{\link{balance_LP}()}
which creates the linear program used by \code{\link{optimize_controls}()} to choose which controls
to select.
}
\keyword{internal}
