% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nrrd-io.R
\name{read.nrrd}
\alias{read.nrrd}
\alias{read.nrrd.header}
\title{Read nrrd file into 3d array in memory}
\usage{
read.nrrd(file, origin = NULL, ReadData = TRUE,
  AttachFullHeader = !ReadData, Verbose = FALSE,
  ReadByteAsRaw = c("unsigned", "all", "none"))

read.nrrd.header(file, Verbose = FALSE)
}
\arguments{
\item{file}{Path to a nrrd (or a connection for \code{read.nrrd.header})}

\item{origin}{Add a user specified origin (x,y,z) to the returned object}

\item{ReadData}{When FALSE just return attributes (e.g. voxel size)}

\item{AttachFullHeader}{Include the full nrrd header as an attribute of the
returned object (default FALSE)}

\item{Verbose}{Status messages while reading}

\item{ReadByteAsRaw}{Either a character vector or a logical vector specifying
when R should read 8 bit data as an R \code{raw} vector rather than
\code{integer} vector.}
}
\value{
a 3D data array with attributes compatible with gjdens objects

A list with elements for the key nrrd header fields
}
\description{
Read nrrd file into 3d array in memory

Read the (text) header of a NRRD format file
}
\details{
ReadByteAsRaw=unsigned (the default) only reads unsigned byte data
  as a raw array. This saves quite a bit of space and still allows data to be
  used for logical indexing.
}

