% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{emr_time2posix}
\alias{emr_time2posix}
\alias{emr_posix2time}
\title{Convert EMR time to POSIXct}
\usage{
emr_time2posix(time, show_hour = FALSE, tz = "UTC")

emr_posix2time(posix)
}
\arguments{
\item{time}{The EMR time to be converted.}

\item{show_hour}{Logical value indicating whether to include the hour in the output. Default is FALSE.}

\item{tz}{Time zone to be used for the output POSIXct object. Default is "UTC".}

\item{posix}{A POSIXct object to be converted to EMR time.}
}
\value{
A POSIXct object representing the converted time.
}
\description{
These function converts EMR time to POSIXct format. It takes the EMR time as input and returns the corresponding POSIXct object.
}
\examples{
# 30 January, 1938, 6:00 - birthday of Islam Karimov
t1 <- emr_date2time(30, 1, 1938, 6)
# September 2, 2016, 7:00 - death of Islam Karimov
t2 <- emr_date2time(2, 9, 2016, 7)

emr_time2posix(c(t1, t2))
emr_time2posix(c(t1, t2), show_hour = TRUE)

emr_posix2time(emr_time2posix(c(t1, t2), show_hour = TRUE))

# Note that when show_hour = FALSE, the hour is set to 0
# and therefore the results would be different from the original time values
emr_posix2time(emr_time2posix(c(t1, t2)))

}
