% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nardl.R
\name{nardl}
\alias{nardl}
\title{Nonlinear ARDL function}
\usage{
nardl(formula, data, p = NULL, q = NULL, ic = c("aic", "bic", "ll", "R2"),
  maxlags = TRUE, graph = FALSE, case = 3)
}
\arguments{
\item{formula}{food~inf or food~inf|I(inf^2)}

\item{data}{the dataframe}

\item{p}{lags of dependent variable}

\item{q}{lags of independent variables}

\item{ic}{: c("aic","bic","ll","R2") criteria model selection}

\item{maxlags}{if TRUE auto lags selection}

\item{graph}{TRUE to show stability tests plot}

\item{case}{case number 3 for (unrestricted intercert, no trend) and 5 (unrestricted intercept, unrestricted trend), 1 2 and 4 not supported}
}
\description{
Nonlinear ARDL function
}
\examples{

############################################
# Fit the nonlinear cointegrating autoregressive distributed lag model
############################################
# Load data
data(fod)
############################################
#example 1: nardl with fixed p and q lags
############################################
reg<-nardl(food~inf,p=4,q=4,fod,ic="aic",maxlags = FALSE,graph = FALSE,case=3)
summary(reg)

############################################
# example 2:auto selected lags (maxlags=TRUE)
############################################
reg<-nardl(food~inf,fod,ic="aic",maxlags = TRUE,graph = FALSE,case=3)
summary(reg)

############################################
# example 3: Cusum and CusumQ plot (graph=TRUE)
############################################
reg<-nardl(food~inf,fod,ic="aic",maxlags = TRUE,graph = TRUE,case=3)

}
