% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{request}
\alias{request}
\title{Request over Context (RPC Client for Req/Rep Protocol)}
\usage{
request(
  context,
  data,
  send_mode = c("serial", "raw"),
  recv_mode = c("serial", "character", "complex", "double", "integer", "logical",
    "numeric", "raw"),
  timeout = -2L,
  keep.raw = TRUE
)
}
\arguments{
\item{context}{a Context.}

\item{data}{an object (if send_mode = 'raw', a vector).}

\item{send_mode}{[default 'serial'] whether data will be sent serialized or
as a raw vector. Use 'serial' for sending and receiving within R to ensure
perfect reproducibility. Use 'raw' for sending vectors of any type (will be
converted to a raw byte vector for sending) - essential when interfacing
with external applications.}

\item{recv_mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.}

\item{timeout}{(optional) integer value in milliseconds. If unspecified, the
default of -2L uses a socket-specific default, which is usually the same
as no timeout. Note that this applies to receiving the result.}

\item{keep.raw}{[default TRUE] logical flag whether to keep the received raw
vector (useful for verification e.g. via hashing). If FALSE, will return
the converted data only.}
}
\value{
A 'recvAio' (object of class 'recvAio').
}
\description{
Implements a caller/client for the req node of the req/rep protocol. Sends
    data to the rep node (executor/server) and returns an Aio, which can be
    called when the result is required.
}
\details{
Sending the request and receiving the result are both performed async,
    hence the function will return immediately with a 'recvAio' object. Access
    the return value at \code{$data}.

    This is designed so that the process on the server can run concurrently
    without blocking the client.

    Optionally use \code{\link{call_aio}} on the 'recvAio' to call (and wait
    for) the result.

    If an error occured in the server process, a nul byte \code{00} will be
    received (as \code{$data} if 'recv_mode' = 'serial', as \code{$raw}
    otherwise). This allows an error to be easily distinguished from a NULL
    return value. \code{\link{is_nul_byte}} can be used to test for a nul byte.
}
\examples{
req <- socket("req", listen = "tcp://127.0.0.1:6546")
rep <- socket("rep", dial = "tcp://127.0.0.1:6546")

ctxq <- context(req)
ctxp <- context(rep)

# works if req and rep are running in parallel in different processes
reply(ctxp, execute = function(x) x + 1, timeout = 10)
aio <- request(ctxq, data = 2022, timeout = 10)
call_aio(aio)

close(req)
close(rep)

}
