% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeS.R
\name{makeS}
\alias{makeS}
\title{Creates the additive genetic relationship matrix for the shared sex
chromosomes}
\usage{
makeS(pedigree, heterogametic, DosageComp = c(NULL, "ngdc", "hori",
  "hedo", "hoha", "hopi"), returnS = FALSE)
}
\arguments{
\item{pedigree}{A pedigree where the columns are ordered ID, Dam, Sire, Sex}

\item{heterogametic}{Character indicating the label corresponding to the
heterogametic sex used in the \dQuote{Sex} column of the pedigree}

\item{DosageComp}{A character indicating which model of dosage compensation.
If \code{NULL} then the \dQuote{ngdc} model is assumed.}

\item{returnS}{Logical statement, indicating if the relationship matrix
should be constructed in addition to the inverse}
}
\value{
a \code{list}:
  \describe{
    \item{model }{the model of sex-chromosome dosage compensation assumed.}
    \item{S }{the sex-chromosome relationship matrix in sparse matrix
      form or NULL if \code{returnS} = FALSE}
    \item{logDet }{the log determinant of the S matrix}
    \item{Sinv }{the inverse of the S matrix in sparse matrix form}
    \item{listSinv }{the three column form of the non-zero elements for the 
      inverse of the S matrix}
    \item{inbreeding }{the sex-linked inbreeding coefficients for all 
      individuals in the pedigree}
    \item{vii }{a vector of the (non-zero) elements of the diagonal V matrix
      of the S=TVT' decomposition. Contains the variance of Mendelian
      sampling for a sex-linked locus}
  }
}
\description{
The function returns the inverse of the additive relationship matrix in
sparse matrix format for the sex chromosomes (e.g., either X or Z).
}
\details{
Missing parents (e.g., base population) should be denoted by either 'NA',
'0', or '*'.

The inverse of the sex-chromosome additive genetic relationship matrix
(S-matrix) is constructed implementing the Meuwissen and Luo (1992)
algorithm to directly construct inverse additive relationship matrices
(borrowing code from Jarrod Hadfield's MCMCglmm function, \code{inverseA})
and using equations presented in Fernando & Grossman (1990; see Wolak et al.
2013).  Additionally, the S-matrix itself can be constructed (although this
takes much longer than computing S-inverse directly).

The choices of dosage compensation models are: no global dosage compensation
("ngdc"), random inactivation in the homogametic sex ("hori"), doubling of
the single shared sex chromosome in the heterogametic sex ("hedo"), halving
expression of both sex chromosomes in the homogametic sex ("hoha"), or
inactivation of the paternal sex chromosome in the homogametic sex ("hopi").
}
\examples{

 makeS(FG90, heterogametic = "0", returnS = TRUE)

}
\references{
Wolak, M.E., D.A. Roff, and D.J. Fairbairn. in prep. The
contribution of sex chromosomal additive genetic (co)variation to the
phenotypic resemblance between relatives under alternative models of dosage
compensation.

Fernando, R.L. & Grossman, M. 1990. Genetic evaluation with autosomal and
X-chromosomal inheritance. Theoretical and Applied Genetics, 80:75-80.

Meuwissen, T.H.E. and Z. Luo. 1992. Computing inbreeding coefficients in
large populations. Genetics, Selection, Evolution, 24:305-313.
}
\author{
\email{matthewwolak@gmail.com}
}
