% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FilterRNASeqCT.R
\name{FilterRNASeqCT}
\alias{FilterRNASeqCT}
\title{Filter Expression Levels in RNASeq Count Tables}
\usage{
FilterRNASeqCT(ExpressionSet, cut.off, method = "const", n = NULL)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{cut.off}{a numeric value specifying the expression cut off to define genes as \emph{not expressed} in case they express values that lie below this threshold.}

\item{method}{a method how to treat gene expression in multiple stages. Options are \code{"const"}, \code{"min-set"}, and \code{"n-set"}.}

\item{n}{a numeric value for \code{method = "n-set"}.}
}
\description{
This function takes an ExpressionSet object that is based
on a RNASeq count table (CT) and removes genes from this CT that
have an expression level below a defined \code{cut.off} value.
}
\details{
This filter function allows users to remove genes from the \code{ExpressionSet} object that undercut a certain expression level \code{cut.off}.

Following extraction criteria are implemented in this function:
\itemize{
\item \code{const}: all genes that have at least one stage that undercuts the expression \code{cut.off} will be excluded from the \code{ExpressionSet}.
\item \code{min-set}: genes that undercut the expression level \code{cut.off} in \code{ceiling(n/2)} stages will be excluded from the \code{ExpressionSet}.
\item \code{n-set}: genes that undercut the expression level \code{cut.off} in \code{n} stages will be excluded from the \code{ExpressionSet}.
}
}
\examples{
data(PhyloExpressionSetExample)

# remove genes that have an expression level below 8000
# in at least one developmental stage
FilterConst <- FilterRNASeqCT(ExpressionSet = PhyloExpressionSetExample,
                              cut.off       = 8000,
                              method        = "const")

dim(FilterConst) # check number of retained genes

# remove genes that have an expression level below 8000
# in at least ceiling(n/2) developmental stages (in this case: ceiling(7/2) = 4 stages)
FilterMinSet <- FilterRNASeqCT(ExpressionSet = PhyloExpressionSetExample,
                               cut.off       = 8000,
                               method        = "min-set")

dim(FilterMinSet) # check number of retained genes

# remove genes that have an expression level below 8000
# in at least n developmental stages (in this case: 5 stages)
FilterNSet <- FilterRNASeqCT(ExpressionSet = PhyloExpressionSetExample,
                             cut.off       = 8000,
                             method        = "n-set",
                             n             = 5)

dim(FilterMinSet) # check number of retained genes
}
\author{
Hajk-Georg Drost
}

