% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{mc_read_data}
\alias{mc_read_data}
\title{Reading files with locality metadata}
\usage{
mc_read_data(
  files_table,
  localities_table = NULL,
  clean = TRUE,
  silent = FALSE,
  user_data_formats = NULL
)
}
\arguments{
\item{files_table}{path to csv file or data.frame object see example](https://github.com/ibot-geoecology/myClim/blob/main/examples/data/TOMST/files_table.csv)
with 3 required columns and few optional:
required columns:
\itemize{
\item path - path to files
\item locality_id - unique locality id
\item data_format see \link{mc_data_formats}, \code{names(mc_data_formats)}
}

optional columns:
\itemize{
\item serial_number - logger serial number. If is NA, than myClim tries to detect serial number from file name (for TOMST) or header (for HOBO)
\item logger_type - type of logger. This defines individual sensors attributes (measurement heights and physical units) of the logger. Important when combining the data from multiple loggers on the locality.
If not provided, myClim tries to detect loger_type from the source data file structure (applicable for HOBO, Dendro, Thermo and TMS), but automatic detection of TMS_L45 is not possible.
Pre-defined logger types are: ("Dendro", "HOBO", "Thermo", "TMS", "TMS_L45")
Default heights of sensor based on logger types are defined in table \link{mc_data_heights}
\item date_format A character vector specifying the custom date format(s) for the \code{\link[lubridate:parse_date_time]{lubridate::parse_date_time()}} function
(e.g., "\%d.\%m.\%Y \%H:\%M:\%S"). Multiple formats can be defined. The first matching format will be selected for parsing.
\item tz_offset - If source datetimes aren't in UTC, then is possible define offset from UTC in minutes.
Value in this column have the highest priority. If NA then auto detection of timezone in files.
If timezone can't be detected, then UTC is supposed.
Timezone offset in HOBO format can be defined in header. In this case function try detect offset automatically.
Ignored for Tomst TMS data format (they are always in UTC)
\item step - Time step of microclimatic time-series in seconds. When provided, then used in \link{mc_prep_clean}
instead of automatic step detection. See details.
}}

\item{localities_table}{path to csv file ("c:/user/localities.table.csv") or R data.frame \href{https://github.com/ibot-geoecology/myClim/blob/main/examples/data/TOMST/localities_table.csv}{ see example}.
Localities table is optional (default NULL).
The \code{locality_id} is the only required column. Other columns are optional. Column names corresponding
with the myclim pre-defined locality metadata (elevation, lon_wgs84, lat_wgs84, tz_offset)
are associted withthose pre-defined metadata slots, other columns are  written into
\code{metadata@user_data} \link{myClim-package}.

required columns:
\itemize{
\item locality_id - unique locality id
}

optional columns:
\itemize{
\item elevation - elevation (in m)
\item lon_wgs84 - longitude (in decimal degrees)
\item lat_wgs84 - latitude (in decimal degrees)
\item tz_offset - locality time zone offset from UTC, applicable for converting time-series from UTC to local time.
\item ... - any other columns are imported to \code{metadata@user_data}
}}

\item{clean}{if TRUE, then \link{mc_prep_clean} is called automatically while reading (default TRUE)}

\item{silent}{if TRUE, then any information is not printed in console (default FALSE)}

\item{user_data_formats}{custom data formats; use in case you have your own logger
files not pre-defined in myClim  - list(key=mc_DataFormat) \linkS4class{mc_DataFormat} (default NULL)

If custom data format is defined the key can be used in data_format parameter in \code{\link[=mc_read_files]{mc_read_files()}}
and \code{\link[=mc_read_data]{mc_read_data()}}. Custom data format must be defined first, and then an be used for reading.}
}
\value{
myClim object in Raw-format see \link{myClim-package}
}
\description{
This function has two tables as the parameters.

(i) \code{files_table} with \emph{paths} pointing to raw
csv logger files, specification of \emph{data format} (logger type) and \emph{locality name}.

(ii) \code{localities_table} with \emph{locality id} and metadata e.g. longitude, latitude, elevation...
}
\details{
The input tables could be R data.frames or csv files. When loading \code{files_table}
and \code{localities_table} from external CSV they must have header, column separator must be comma ",".

By default, data are cleaned with the function \link{mc_prep_clean} see function description.
\link{mc_prep_clean} detects gaps in time-series data,
duplicated records, or records in the wrong order. Importantly, \link{mc_prep_clean}
also applies a \strong{step parameter} if provided. The step parameter can be used either
instead of automatic step detection which can sometime failed, or to prune
microclimatic data. For example, if you have a 15-minute time series but you wish to
keep only one record per hour (without aggregating), you can use step parameter.
However, if a step is provided and \code{clean = FALSE}, then the step is only stored in the
metadata of myClim, and the time-series data is not cleaned, and the step is not applied.
}
\examples{
files_csv <- system.file("extdata", "files_table.csv", package = "myClim")
localities_csv <- system.file("extdata", "localities_table.csv", package = "myClim")
tomst_data <- mc_read_data(files_csv, localities_csv)
}
\seealso{
\link{mc_DataFormat}
}
