% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mc_plot_raster}
\alias{mc_plot_raster}
\title{Plot data - ggplot2 geom_raster}
\usage{
mc_plot_raster(
  data,
  filename = NULL,
  sensors = NULL,
  by_hour = TRUE,
  png_width = 1900,
  png_height = 1900,
  viridis_color_map = NULL,
  start_crop = NULL,
  end_crop = NULL
)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{filename}{output with the extension - supported formats are .pdf and .png (default NULL)
If NULL then the plot is shown/returned into R environment as ggplot object, but not saved to file.}

\item{sensors}{names of sensor; should have same physical unit see \code{names(mc_data_sensors)}}

\item{by_hour}{if TRUE, then y axis is plotted as an hour, else original time step (default TRUE)}

\item{png_width}{width for png output (default 1900)}

\item{png_height}{height for png output (default 1900)}

\item{viridis_color_map}{viridis color map option; if NULL, then used value from mc_data_physical
\itemize{
\item "A" - magma
\item "B" - inferno
\item "C" - plasma
\item "D" - viridis
\item "E" - cividis
\item "F" - rocket
\item "G" - mako
\item "H" - turbo
}}

\item{start_crop}{POSIXct datetime for crop data (default NULL)}

\item{end_crop}{POSIXct datetime for crop data (default NULL)}
}
\value{
list of ggplot2 objects
}
\description{
Function plots data with ggplot2 geom_raster. Plot is returned as ggplot faced raster and
is primary designed to be saved as .pdf file (recommended) or .png file.
Plotting into R environment without saving any file is also possible.
See details.
}
\details{
Saving as the .pdf file is recommended, because the plot is optimized
to be paginate PDF (facet raster plot is distributed to pages), which is especially useful
for bigger data. In case of plotting multiple sensors to PDF, the facet grids are grouped by sensor.
I.e., all localities of sensor_1 followed by all localities of sensor_2 etc.
When plotting only few localities, but multiple sensors,
each sensor has own page. I.e., when plotting data from one locality, and 3 sensors resulting PDF has 3 pages.
In case of plotting PNG, sensors are plotted in separated images (PNG files) by physical.
I.e, when plotting 3 sensors in PNG it will save 3 PNG files named after sensors.
Be careful with bigger data in PNG. Play with \code{png_height} and \code{png_width}.
When too small height/width, image does not fit and is plotted incorrectly. Plotting into
R environment instead of saving PDF or PNG is possible, but is recommended only for
low number  of localities (e.g. up to 10), because
high number of localities plotted in R environment results in very small picture which is hard/impossible to read.
}
\examples{
tmp_dir <- tempdir()
tmp_file <- tempfile(tmpdir = tmp_dir, fileext=".pdf")
mc_plot_raster(mc_data_example_agg, filename=tmp_file, sensors=c("TMS_T3","TM_T"))
file.remove(tmp_file)
}
