% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_summary_functions.R
\name{extract_summary_functions}
\alias{extract_summary_functions}
\title{Extract Summary Functions}
\usage{
extract_summary_functions(
  mxFDAobject,
  r_vec = seq(0, 100, by = 10),
  extract_func = c(univariate, bivariate),
  summary_func = c(Kest, Lest, Gest),
  markvar,
  mark1,
  mark2 = NULL,
  edge_correction,
  breaks = NULL
)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA}}

\item{r_vec}{Numeric vector of radii over which to evaluate spatial summary functions. Must begin at 0.}

\item{extract_func}{Defaults to univariate, which calculates univariate spatial summary functions. Choose bivariate for bivariate spatial summary functions.}

\item{summary_func}{Spatial summary function to calculate. Options are c(Kest, Lest, Gest) which denote Ripley's K, Besag's L, and nearest neighbor G function, respectively.}

\item{markvar}{The name of the variable that denotes cell type(s) of interest. Character.}

\item{mark1}{Character string that denotes first cell type of interest.}

\item{mark2}{Character string that denotes second cell type of interest for calculating bivariate summary statistics. Not used when calculating univariate statistics.}

\item{edge_correction}{Character string that denotes the edge correction method for spatial summary function. For Kest and Lest choose one of c("border", "isotropic", "Ripley", "translate", "none"). For Gest choose one of c("rs", "km", "han")}

\item{breaks}{integer value for number of breaks in r_vec. Used only for entropy measure}
}
\value{
an object of class \code{mxFDA} containing the corresponding spatial summary function slot filled. See \code{\link[=make_mxfda]{make_mxfda()}} for object structure details.
}
\description{
Function to extract spatial summary functions from the \code{Spatial} slot of an \code{mxFDA} object
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian FDA object
data('ovarian_FDA')

#run function
ovarian_FDA = extract_summary_functions(ovarian_FDA, r_vec = 0:100,
                                        extract_func = univariate,
                                        summary_func = Kest,
                                        markvar = "immune",
                                        mark1 = "immune",
                                        edge_correction = "trans")

}
\references{
Xiao, L., Ruppert, D., Zipunnikov, V., and Crainiceanu, C. (2016).
Fast covariance estimation for high-dimensional functional data.
\emph{Statistics and Computing}, 26, 409-421.
DOI: 10.1007/s11222-014-9485-x.

\code{\link[spatstat.explore:Kest]{spatstat.explore::Kest()}}

\code{\link[spatstat.explore:Gest]{spatstat.explore::Gest()}}

\code{\link[spatstat.explore:Lest]{spatstat.explore::Lest()}}

\code{\link[spatstat.explore:Kcross]{spatstat.explore::Kcross()}}

\code{\link[spatstat.explore:Gcross]{spatstat.explore::Gcross()}}

\code{\link[spatstat.explore:Lcross]{spatstat.explore::Lcross()}}
}
\author{
Julia Wrobel \email{julia.wrobel@emory.edu}

Alex Soupir \email{alex.soupir@moffitt.org}
}
