% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{IMMV}
\alias{IMMV}
\title{Random Generation for Distribution with Independent Marginals}
\usage{
IMMV(n, p, q = NULL, D1, D2 = NULL, D1.args = list(), D2.args = list())
}
\arguments{
\item{n}{number of rows (observations).}

\item{p}{total number of columns (variables).}

\item{q}{number of columns from distribution \code{D1} if generate multivariate samples from independent marginal distribution \eqn{D_1} and \eqn{D_2}.
Default is \code{NULL}, i.e., generating samples only from one distribution.}

\item{D1}{random generation function for 1st distribution (e.g., \code{rnorm}, \code{rbeta}).}

\item{D2}{random generation function for 2nd distribution (e.g., \code{rnorm}, \code{rbeta}).}

\item{D1.args}{a list of optional arguments passed to \code{D1}.}

\item{D2.args}{a list of optional arguments passed to \code{D2}.}
}
\value{
Returns univariate (\eqn{p=1}) or multivariate (\eqn{p>1}) random sample matrix.
}
\description{
Generate univariate or multivariate random sample for distribution with independent marginals such that \eqn{D_1 \otimes D_2}.
\eqn{D_1 \otimes D_2} denotes the distribution having independent marginal distributions \eqn{D_1} and \eqn{D_2}. This function can generate
multivariate random samples only from distribution \eqn{D_1} or from both \eqn{D_1} and \eqn{D_2}.
}
\examples{
set.seed(12345)

## Generate 5X2 random sample matrix from IMMV(N(0,1),Beta(1,2)) ##
IMMV(n=5, p=2, q=1, D1=rbeta, D1.args=list(shape1=1,shape2=2), D2=rnorm)


## Power calculation against bivariate (p=2) IMMV(Gamma(5,1)) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

# Zhou-Shao's test #
power.mvnTest(a=0.05, n=50, p=2, B=100, FUN=IMMV, D1=rgamma, D1.args=list(shape=5, rate=1))

## Power calculation against bivariate (p=2) IMMV(N(0,1),Beta(1,2)) distribution ##
## at sample size n=50 at one-sided alpha = 0.05 ##

# Zhou-Shao's test #
power.mvnTest(a=0.05, n=50, p=2, B=100, FUN=IMMV, q=1, D1=rbeta, D1.args=list(shape1=1,shape2=2),
D2=rnorm)

}
\references{
Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.

Henze, N., & Zirkler, B. (1990). A class of invariant consistent tests for multivariate normality. \emph{Communications in statistics-Theory and Methods}, 19(10), 3595-3617.
}
