% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmcd.R
\name{dmcd}
\alias{dmcd}
\title{Density of a Multivariate Cauchy Distribution}
\usage{
dmcd(x, mu, Sigma, tol = 1e-6)
}
\arguments{
\item{x}{length \eqn{p} numeric vector.}

\item{mu}{length \eqn{p} numeric vector. The location parameter.}

\item{Sigma}{symmetric, positive-definite square matrix of order \eqn{p}. The scatter matrix.}

\item{tol}{tolerance (relative to largest eigenvalue) for numerical lack of positive-definiteness in Sigma.}
}
\value{
The value of the density.
}
\description{
Density of the multivariate (\eqn{p} variables) Cauchy distribution (MCD)
with location parameter \code{mu} and scatter matrix \code{Sigma}.
}
\details{
The density function of a multivariate Cauchy distribution is given by:
\deqn{ \displaystyle{ f(\mathbf{x}|\boldsymbol{\mu}, \Sigma) = \frac{\Gamma\left(\frac{1+p}{2}\right)}{\pi^{p/2} \Gamma\left(\frac{1}{2}\right) |\Sigma|^\frac{1}{2} \left[ 1 + (\mathbf{x}-\boldsymbol{\mu})^T \Sigma^{-1} (\mathbf{x}-\boldsymbol{\mu}) \right]^\frac{1+p}{2}} } }
}
\examples{
mu <- c(0, 1, 4)
sigma <- matrix(c(1, 0.6, 0.2, 0.6, 1, 0.3, 0.2, 0.3, 1), nrow = 3)
dmcd(c(0, 1, 4), mu, sigma)
dmcd(c(1, 2, 3), mu, sigma)

}
\seealso{
\code{\link{rmcd}}: random generation from a MCD.

\code{\link{estparmcd}}: estimation of the parameters of a MCD.

\code{\link{plotmvd}}, \code{\link{contourmvd}}: plot of the probability density of a bivariate distribution.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
