% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{ws2}
\alias{ws2}
\title{Within-subjects 2×2 design with dichotomous response}
\format{
A data frame with 60 observations on the following 4 variables:
\describe{
\item{PId}{a subject identifier with levels \code{"1"} ... \code{"10"}}
\item{X1}{a within-subjects factor with levels \code{"a"}, \code{"b"}}
\item{X2}{a within-subjects factor with levels \code{"c"}, \code{"d"}}
\item{Y}{a dichotomous response with categories \code{"yes"}, \code{"no"}}
}
}
\description{
This generic synthetic dataset has a dichotomous response \code{Y} and two factors
\code{X1} and \code{X2}. The response has categories \code{\{yes,no\}}.
Factor \code{X1} has levels \code{\{a,b\}}, and factor \code{X2} has levels
\code{\{c,d\}}. It also has a \code{PId} column for participant identifier.
Participant identifiers are repeated across rows.
}
\examples{
data(ws2, package="multpois")

ws2$PId = factor(ws2$PId)
ws2$Y = factor(ws2$Y, levels=c("yes","no"))
ws2$X1 = factor(ws2$X1)
ws2$X2 = factor(ws2$X2)
contrasts(ws2$X1) <- "contr.sum"
contrasts(ws2$X2) <- "contr.sum"

m = glmer.mp(Y ~ X1*X2 + (1|PId), data=ws2)
Anova.mp(m, type=3)
glmer.mp.con(m, pairwise ~ X1*X2, adjust="holm")

}
\seealso{
See \code{\link{glmer.mp}} and \code{\link{glmer.mp.con}} for complete examples.
}
\keyword{datasets}
