% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\docType{package}
\name{multivariance-package}
\alias{multivariance-package}
\title{Multivariance: detecting and measuring multivariate dependence}
\description{
The multivariance package provides basic functions to calculate distance multivariance and related quantities.
}
\details{
Distance multivariance is a measure of dependence which can be used to detect and quantify dependence structures. The necessary functions are implemented in this packages, and examples are given. For the theoretic background we refer to the forthcoming papers [1,2].

The (current) code should be understood as \emph{proof of concept}, certainly there is room for improvement and development. Questions, comments and remarks are welcome: \email{bjoern.boettcher@tu-dresden.de}
}
\section{Multivariance}{


 \code{\link{multivariance}} computes the distance multivariance

 \code{\link{total.multivariance}} computes the total distance multivariance
}

\section{Functions to use and interpret multivariance}{


 \code{\link{rejection.level}} computes the rejection level for a given significance level. This can be used for a sensitive (conservative) interpretation of distance multivariance. The counterpart is \code{\link{multivariance.pvalue}}, which computes the pvalue for a given distance multivariance. Both use the hypothesis of independence.

 \code{\link{independence.test}} provides the corresponding test of independence.

\code{\link{cdm}} and \code{\link{cdms}} compute the centered distance matrix and matrices, respectively. These can be used for faster computation of distance multivariance.
}

\section{Examples}{


\code{\link{coins}} and \code{\link{tetrahedron}} generate samples of pairwise independent random variables, with dependence of higher order.
}

\references{
[1] B. Böttcher, M. Keller-Ressel, R.L. Schilling, Detecting independence of random vectors I. Generalized distance covariance and Gaussian covariance. Preprint 2017.

[2] B. Böttcher, M. Keller-Ressel, R.L. Schilling, Detecting independence of random vectors II. Distance multivariance and Gaussian multivariance. Preprint 2017.
}
