% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{transmute}
\alias{transmute}
\alias{transmute_}
\title{Change variables and drop all others}
\usage{
transmute(.self, ...)

transmute_(.self, ..., .dots)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
This function works like a combination of \code{mutate} and \code{select}: it may be used to modify values in a data frame, and then drops any column not explicitly specified
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, y=100:1)
dat \%>\% mutate (x=x*2)
dat \%>\% shutdown()
}
}
\seealso{
Other data manipulations: \code{\link{mutate}},
  \code{\link{nsa}}, \code{\link{reduce}},
  \code{\link{summarise}}, \code{\link{within_group}},
  \code{\link{within_node}}
}

