% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_marginal.R
\name{strategy_postprob}
\alias{strategy_postprob}
\title{Strategy Classification: Posterior Model Probabilities}
\usage{
strategy_postprob(k, n, strategies, cpu = 1)
}
\arguments{
\item{k}{observed frequencies of Option B.
Either a vector or a matrix/data frame (one person per row).}

\item{n}{vector with the number of choices per item type.}

\item{strategies}{list of strategies. See \link{strategy_multiattribute}}

\item{cpu}{number of processing units for parallel computation.}
}
\description{
Posterior model probabilities for multiple strategies (with equal prior model probabilities).
}
\examples{
# pattern 1: A, A, B with constant error e<.50
strat1 <- list(
  pattern = c(-1, -1, 1),
  c = .5, ordered = FALSE,
  prior = c(1, 1)
)
# pattern 2: A, B, B with ordered error e1<e3<e2<.50
strat2 <- list(
  pattern = c(-1, 3, 2),
  c = .5, ordered = TRUE,
  prior = c(1, 1)
)
baseline <- list(
  pattern = 1:3, c = 1, ordered = FALSE,
  prior = c(1, 1)
)

# data
k <- c(3, 4, 12) # frequencies Option B
n <- c(20, 20, 20) # number of choices
strategy_postprob(k, n, list(strat1, strat2, baseline))
}
\seealso{
\code{\link{strategy_marginal}} and \code{\link{model_weights}}
}
