% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{inside}
\alias{inside}
\title{Check Whether Points are Inside a Convex Polytope}
\usage{
inside(x, A, b, V)
}
\arguments{
\item{x}{a vector of length equal to the number of columns of \code{A} or \code{V}
(i.e., a single point in D-dimensional space) or matrix of points/vertices (one per row).}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}
}
\description{
Determines whether a point \code{x} is inside a convex poltyope by checking whether
(1) all inequalities \code{A*x <= b} are satisfied or
(2) the point \code{x} is in the convex hull of the vertices in \code{V}.
}
\examples{
# linear order constraints:  x1<x2<x3<.5
A <- matrix(c(1,-1, 0,
              0, 1,-1,
              0, 0, 1), ncol = 3, byrow = TRUE)
b <- c(0, 0, .50)

# vertices: admissible points (corners of polytope)
V <- matrix(c( 0, 0, 0,
               0, 0,.5,
               0,.5,.5,
              .5,.5,.5), ncol = 3, byrow = TRUE)

xin <- c(.1, .2, .45)  # inside
inside(xin, A, b)
inside(xin, V = V)

xout <- c(.4, .1, .55)  # outside
inside(xout, A, b)
inside(xout, V = V)
}
\seealso{
\code{\link{Ab_to_V}} and \code{\link{V_to_Ab}} to change between A/b and V representation.
}
