% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_delta.R
\name{adapt_delta}
\alias{adapt_delta}
\title{Target average acceptance probability}
\description{
The Stan control argument \code{adapt_delta} sets the target average acceptance
probability for the No-U-Turn Sampler (NUTS) used by Stan.
}
\details{
The default value of \code{adapt_delta} used by \code{\link[=nma]{nma()}} is 0.8 for fixed
effect models, and 0.95 for random effects models.

You should not need to change \code{adapt_delta} unless you see a warning
message about divergent transitions. Increasing \code{adapt_delta} from the
default to a value closer to 1 means that Stan will use a smaller step
size, making sampling slower but more robust, and resulting in fewer
divergent transitions.

For more details see the Stan documentation available from
https://mc-stan.org/users/documentation/.
}
