% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevelMatchX.R
\name{multilevelMatchX}
\alias{multilevelMatchX}
\title{Matching on X with multilevel treatments}
\usage{
multilevelMatchX(Y, W, X)
}
\arguments{
\item{Y}{A continuous response vector (1 x n)}

\item{W}{A treatment vector (1 x n) with numerical values indicating
treatment groups}

\item{X}{A covariate matrix (p x n) with no intercept}
}
\value{
A list with 2 elements: \code{tauestimate}, \code{varestimate}, where
  \code{tauestimate} is a vector of estimates for pairwise treatment effects,
  and \code{varestimate} is a vector of variance estimates for
  \code{tauestimate}, using Abadie & Imbens (2006)'s method.
}
\description{
Matching on X with multilevel treatments
}
\examples{
  X<-c(5.5,10.6,3.1,8.7,5.1,10.2,9.8,4.4,4.9)
  Y<-c(102,105,120,130,100,80,94,108,96)
  W<-c(1,1,1,3,2,3,2,1,2)
  multilevelMatchX(Y,W,X)

}
\references{
Yang, S., Imbens G. W., Cui, Z., Faries, D. E., & Kadziola, Z.
  (2016) Propensity Score Matching and Subclassification in Observational
  Studies with Multi-Level Treatments. Biometrics, 72, 1055-1065.
  \url{https://doi.org/10.1111/biom.12505}

  Abadie, A., & Imbens, G. W. (2006). Large sample properties of matching
  estimators for average treatment effects. econometrica, 74(1), 235-267.
  \url{https://doi.org/10.1111/j.1468-0262.2006.00655.x}

  Abadie, A., & Imbens, G. W. (2016). Matching on the estimated propensity
  score. Econometrica, 84(2), 781-807.
  \url{https://doi.org/10.3982/ECTA11293}

  Crump, R. K., Hotz, V. J., Imbens, G. W., & Mitnik, O. A. (2009). Dealing
  with limited overlap in estimation of average treatment effects.
  Biometrika, 96(1), 187-199. \url{https://doi.org/10.1093/biomet/asn055}
}
\seealso{
\code{\link{multilevelGPSMatch}};
  \code{\link{multilevelGPSStratification}}
}
